(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14225,        520]*)
(*NotebookOutlinePosition[     15072,        547]*)
(*  CellTagsIndexPosition[     15028,        543]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.
Make modifications to any definition using commands in the Format menu.\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  ScriptMinSize->9,
  Background->RGBColor[0.645319, 0.743114, 0.256901]],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  Background->GrayLevel[0.8],
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "ColorPrintout"],
  PageWidth->PaperWidth,
  Background->RGBColor[0.645319, 0.743114, 0.256901],
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellFrame->{{0, 0}, {3, 0}},
  CellMargins->{{75, Inherited}, {8, 10}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  LineSpacing->{1, 0},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->36,
  FontWeight->"Bold",
  FontColor->RGBColor[0.948333, 0.961379, 0.256046]],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{63, Inherited}, {8, 10}},
  FontSize->24,
  FontColor->GrayLevel[1]],

Cell[StyleData["Title", "ColorPrintout"],
  CellMargins->{{63, Inherited}, {8, 10}},
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{48, Inherited}, {2, 20}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24,
  FontWeight->"Bold",
  FontColor->GrayLevel[1]],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{36, Inherited}, {2, 20}},
  FontSize->18],

Cell[StyleData["Subtitle", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {2, 20}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{48, Inherited}, {6, 2}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{36, Inherited}, {6, 2}}],

Cell[StyleData["Subsubtitle", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {6, 2}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{5, 0}, {0, 2}},
  CellDingbat->None,
  CellMargins->{{30, 20}, {10, 30}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->{{13, 4}, {6, 6}},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold",
  FontColor->GrayLevel[1]],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{18, 20}, {10, 30}},
  FontSize->12],

Cell[StyleData["Section", "ColorPrintout"],
  CellMargins->{{18, 20}, {10, 30}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{48, Inherited}, {Inherited, 18}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{36, Inherited}, {Inherited, 18}},
  FontSize->12],

Cell[StyleData["Subsection", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {Inherited, 18}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{48, Inherited}, {Inherited, 12}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  CounterIncrements->"Subsubsection",
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{36, Inherited}, {Inherited, 12}},
  FontSize->10],

Cell[StyleData["Subsubsection", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {Inherited, 12}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{48, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 6}],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{36, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 5},
  FontSize->10],

Cell[StyleData["Text", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 5},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{48, Inherited}, {Inherited, Inherited}},
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{36, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 3},
  FontSize->8],

Cell[StyleData["SmallText", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 3},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{1, 1}, {0, 1}},
  CellMargins->{{48, Inherited}, {0, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontSize->16,
  FontWeight->"Bold",
  Background->RGBColor[0.990173, 0.734493, 0.951598]],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{36, Inherited}, {0, Inherited}},
  FontSize->14,
  Background->GrayLevel[0.8]],

Cell[StyleData["Input", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {0, Inherited}},
  FontSize->14]
}, Closed]],

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{1, 1}, {1, 0}},
  CellMargins->{{48, Inherited}, {Inherited, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{15, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Output",
  Background->RGBColor[0.969436, 0.727916, 0.508858]],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{36, Inherited}, {Inherited, 0}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Output", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {Inherited, 0}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
  CellFrame->1,
  CellMargins->{{48, Inherited}, {0, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{15, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontSize->16,
  FontWeight->"Bold",
  Background->RGBColor[0.990173, 0.734493, 0.951598]],

Cell[StyleData["InputOnly", "Printout"],
  CellMargins->{{36, Inherited}, {0, Inherited}},
  FontSize->14,
  Background->GrayLevel[0.8]],

Cell[StyleData["InputOnly", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {0, Inherited}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellDingbat->"\[LongDash]",
  CellMargins->{{70, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{15, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontSlant->"Oblique",
  FontColor->GrayLevel[1]],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{58, Inherited}, {Inherited, Inherited}},
  FontSize->10],

Cell[StyleData["Message", "ColorPrintout"],
  CellMargins->{{58, Inherited}, {Inherited, Inherited}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{48, 20}, {3, 3}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{15, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Left,
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None,
  Background->GrayLevel[0.760281]],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{36, 20}, {3, 3}},
  FontSize->10],

Cell[StyleData["Print", "ColorPrintout"],
  CellMargins->{{36, 20}, {3, 3}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{48, Inherited}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->RGBColor[0.965682, 0.919066, 0.758984]],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{36, Inherited}, {0, 0}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Graphics", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {0, 0}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{48, Inherited}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  ShowCellLabel->False,
  CounterIncrements->"Graphics",
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->RGBColor[0.965682, 0.919066, 0.758984]],

Cell[StyleData["PictureGroup", "Printout"],
  CellMargins->{{36, Inherited}, {0, 0}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["PictureGroup", "ColorPrintout"],
  CellMargins->{{36, Inherited}, {0, 0}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->8,
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "ColorPrintout"],
  FontSize->8]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0 Beta 3",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{479, 327},
WindowMargins->{{12, Automatic}, {Automatic, 2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 52, "Subtitle"],
Cell[1771, 53, 193, 5, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 62, 42, 0, 50, "Section"],
Cell[2034, 64, 105, 2, 52, 31, 0, "StyleData", "All", "Working"],
Cell[2142, 68, 134, 3, 52, 32, 0, "StyleData", "All", "Printout"],
Cell[2279, 73, 163, 3, 52, 37, 0, "StyleData", "All", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2479, 81, 35, 0, 38, "Section"],
Cell[2517, 83, 101, 3, 30, "Text"],
Cell[2621, 88, 398, 10, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3056, 103, 38, 0, 38, "Section"],

Cell[CellGroupData[{
Cell[3119, 107, 453, 12, 81, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3575, 121, 122, 3, 70, 36, 0, "StyleData", "Title", "Printout"],
Cell[3700, 126, 100, 2, 70, 41, 0, "StyleData", "Title", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3837, 133, 363, 10, 55, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[4203, 145, 98, 2, 56, 39, 0, "StyleData", "Subtitle", "Printout"],
Cell[4304, 149, 103, 2, 56, 44, 0, "StyleData", "Subtitle", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4444, 156, 315, 8, 49, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4762, 166, 84, 1, 39, 42, 0, "StyleData", "Subsubtitle", "Printout"],
Cell[4849, 169, 89, 1, 39, 47, 0, "StyleData", "Subsubtitle", "ColorPrintout"]

}, Closed]],

Cell[CellGroupData[{
Cell[4975, 175, 414, 12, 60, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[5392, 189, 91, 2, 77, 38, 0, "StyleData", "Section", "Printout"],
Cell[5486, 193, 96, 2, 77, 43, 0, "StyleData", "Section", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5619, 200, 332, 9, 46, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[5954, 211, 108, 2, 51, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[6065, 215, 113, 2, 51, 46, 0, "StyleData", "Subsection", "ColorPrintout"]

}, Closed]],

Cell[CellGroupData[{
Cell[6215, 222, 281, 7, 45, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[6499, 231, 111, 2, 42, 44, 0, "StyleData", "Subsubsection", "Printout"],
Cell[6613, 235, 116, 2, 42, 49, 0, "StyleData", "Subsubsection", 
"ColorPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6778, 243, 39, 0, 38, "Section"],

Cell[CellGroupData[{
Cell[6842, 247, 104, 2, 36, 23, 0, "StyleData", "Text", "All"],
Cell[6949, 251, 132, 3, 35, 35, 0, "StyleData", "Text", "Printout"],
Cell[7084, 256, 137, 3, 35, 40, 0, "StyleData", "Text", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7258, 264, 128, 3, 42, 28, 0, "StyleData", "SmallText", "All"],
Cell[7389, 269, 136, 3, 32, 40, 0, "StyleData", "SmallText", "Printout"],
Cell[7528, 274, 141, 3, 32, 45, 0, "StyleData", "SmallText", "ColorPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7718, 283, 42, 0, 38, "Section"],
Cell[7763, 285, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[8036, 294, 560, 16, 53, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[8599, 312, 132, 3, 70, 36, 0, "StyleData", "Input", "Printout"],
Cell[8734, 317, 107, 2, 70, 41, 0, "StyleData", "Input", "ColorPrintout"]
}, Closed]],
Cell[8856, 322, 375, 12, 45, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],

Cell[CellGroupData[{
Cell[9256, 338, 531, 14, 49, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[9790, 354, 138, 3, 70, 37, 0, "StyleData", "Output", "Printout"],
Cell[9931, 359, 108, 2, 70, 42, 0, "StyleData", "Output", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10076, 366, 549, 16, 62, 28, 0, "StyleData", "InputOnly", "All",
  CounterIncrements->"Input"],
Cell[10628, 384, 136, 3, 52, 40, 0, "StyleData", "InputOnly", "Printout"],
Cell[10767, 389, 111, 2, 52, 45, 0, "StyleData", "InputOnly", "ColorPrintout"]

}, Closed]],

Cell[CellGroupData[{
Cell[10915, 396, 527, 15, 45, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[11445, 413, 112, 2, 34, 38, 0, "StyleData", "Message", "Printout"],
Cell[11560, 417, 117, 2, 34, 43, 0, "StyleData", "Message", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11714, 424, 510, 15, 59, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[12227, 441, 87, 2, 70, 36, 0, "StyleData", "Print", "Printout"],
Cell[12317, 445, 92, 2, 70, 41, 0, "StyleData", "Print", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12446, 452, 509, 14, 56, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[12958, 468, 132, 3, 70, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[13093, 473, 102, 2, 70, 44, 0, "StyleData", "Graphics", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13232, 480, 392, 10, 56, 31, 0, "StyleData", "PictureGroup", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[13627, 492, 136, 3, 43, 43, 0, "StyleData", "PictureGroup", "Printout"],
Cell[13766, 497, 106, 2, 43, 48, 0, "StyleData", "PictureGroup", 
"ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13909, 504, 128, 4, 42, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[14040, 510, 82, 2, 32, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[14125, 514, 60, 1, 32, 45, 0, "StyleData", "CellLabel", "ColorPrintout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

